 ; Ŀ
 ;   Pulp - add block names to the Blup Auto-update Xrecord.               
 ;   See Blup.lsp for an explanation of why this might be desirable.       
 ;   Copyright 2003 by Rocket Software Ltd.                                
 ;   Also contains the utilities:                                          
 ;   Blix - show which blocks are already set.                             
 ;   Dpulp - remove a name from the xrecord.                               
 ;   Epulp - remove all unreferenced names from the xrecord.               
 ;   Hpulp - highlight all blocks named in the xrecord.                    
 ;                                                                         
 ; 

              
 ; Ŀ
 ;   Blix - utility - get the data from the Blup xrecord.                  
 ;   Takes no arguments, calls nothing, returns nothing, but is quiet      
 ;   and polite.                                                           
 ; 
 (DEFUN C:BLIX ()
  (print (xistr "blup"))
 (princ))
 ; Ŀ
 ;   Blix end.                                                             
 ; 

 ; Ŀ
 ;   Some of the Xrecord subroutines are not at the present time entirely  
 ;   essential, but it would be impolite to erase them.                    
 ; 
 ; Ŀ
 ;   Kill an xrecord entity.                                               
 ;   Arguments: Recnam, the Xrecord name string.                           
 ;   Calls nothing, returns nothing.                                       
 ; 
 (defun KLIX (recnam)
  (dictremove (namedobjdict) recnam)
 (princ))
 ; Ŀ
 ;   Subroutine Klix end.                                                  
 ; 

 ; Ŀ
 ;   Lixt - get an xrecord entity listing.                                 
 ;   Arguments: Recnam, the Xrecord name string.                           
 ;   Calls nothing, returns an entity data list.                           
 ; 
 (defun LIXT (recnam)
  (dictsearch (namedobjdict) recnam))
 ; Ŀ
 ;   Subroutine Lixt end.                                                  
 ; 

 ; Ŀ
 ;   Maex: Make an xrecord entity.                                         
 ;   Arguments: Recnam, the Xrecord name string.                           
 ;              Dalist, the list of strings.                               
 ;   This can't be used to update an existing xrecord, it must be          
 ;   destroyed and replaced.                                               
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN MAEX (recnam dalist / xrec xname malist)
  (mapcar '(lambda (sub) (setq malist (cons (cons 1 sub) malist)))
            dalist)
  (setq dalist (append '((0 . "XRECORD") (100 . "AcDbXrecord")) malist))
  (dictadd (namedobjdict) recnam (entmakex dalist))
 (princ))
 ; Ŀ
 ;   Subroutine Maex end.                                                  
 ; 

 ; Ŀ
 ;   Recux - add strings to an xrecord entity.                             
 ;   Arguments: Recnam, the Xrecord name string.                           
 ;              Txlist, the list of strings to add.                        
 ;   Calls Xist and Klix, returns nothing.                                 
 ; 
 (DEFUN RECUX (xrcnam txlist / xrec sub malist dalist)
  (setq dalist (xist xrcnam))
  (mapcar '(lambda (sub) (setq malist (cons (cons 1 sub) malist)))
            txlist)
  (setq malist (reverse malist))
 ; Ŀ
 ;   Only add strings which are not already present.                       
 ; 
  (while (setq sub (car malist))
         (setq malist (cdr malist))
         (if (not (member sub dalist))
             (setq dalist (append dalist (list sub)))))
 ; Ŀ
 ;   Destroy the existing Xrecord entity.                                  
 ; 
  (klix xrcnam)
  (setq dalist (append '((0 . "XRECORD") (100 . "AcDbXrecord")) dalist))
  (dictadd (namedobjdict) xrcnam (entmakex dalist))
 (princ))
 ; Ŀ
 ;   Subroutine Recux end.                                                 
 ; 

 ; Ŀ
 ;   Remux - remove strings from an xrecord entity.                        
 ;   Arguments: Xrcnam, the Xrecord name string.                           
 ;              Txlist, the list of strings to remove.                     
 ;   Calls Xist and Klix, returns nothing.                                 
 ;   Note that duplicate strings will all be removed.                      
 ; 
 (DEFUN REMUX (xrcnam txlist / xrec sub malist dalist)
  (setq dalist (xist xrcnam))
  (mapcar '(lambda (sub)
            (if (not (member (cdr sub) txlist))
                (setq malist (cons sub malist))))
            dalist)
  (setq malist (reverse malist))
  (klix xrcnam)
  (setq dalist (append '((0 . "XRECORD") (100 . "AcDbXrecord")) malist))
  (dictadd (namedobjdict) xrcnam (entmakex dalist))
 (princ))
 ; Ŀ
 ;   Subroutine Remux end.                                                 
 ; 

 ; Ŀ
 ;   Xist - returns a list of the 1 association sublists from a named      
 ;   xrecord entity.                                                       
 ;   Arguments: Recnam, the Xrecord name string.                           
 ;   Calls nothing, returns a list.                                        
 ; 
 (defun XIST (recnam / listax sub malist)
  (setq listax (dictsearch (namedobjdict) recnam))
  (mapcar '(lambda (sub)
            (if (= (car sub) 1)
                (setq malist (cons sub malist))))
            listax)
 (reverse malist))
 ; Ŀ
 ;   Subroutine Xist end.                                                  
 ; 

 ; Ŀ
 ;   Xistr - Returns a list of strings from a named xrecord entity.        
 ;   Arguments: Recnam, the Xrecord name string.                           
 ;   Calls nothing, returns a list.                                        
 ; 
 (defun XISTR (recnam / listax sub malist)
  (setq listax (dictsearch (namedobjdict) recnam))
  (mapcar '(lambda (sub)
            (if (= (car sub) 1)
                (setq malist (cons (strcase (cdr sub) t) malist))))
            listax)
 (reverse malist))
 ; Ŀ
 ;   Subroutine Xistr end.                                                 
 ; 

 ; Ŀ
 ;   Xrefp: see if a given block is an xref.                               
 ;   Argument: Enam, either a block name string or an insert entity name.  
 ;   Returns T if enam describes an xref, nil otherwise.                   
 ; 
 (DEFUN XREFP (enam / isxrf xp dat)
  (if (= (type enam) 'ENAME)
      (setq enam (cdr (assoc 2 (entget enam)))))
  (if (and (= (type enam) 'STR)
           (setq dat (tblsearch "block" enam)))
      (progn
           (setq xp (cdr (assoc 70 dat)))
           (setq isxrf (logand xp 4))))
 (if (and xp (= isxrf 4)) T ()))
 ; Ŀ
 ;   Xrefp end.                                                            
 ; 

 ; Ŀ
 ;   Dpulp - remove a block name from the Blup xrecord.                    
 ; 
 (DEFUN C:DPULP (/ enampt enam typ blnam lissa)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Get an entity, remove its name from the Blup Xrecord.                 
 ; 
  (cond ((null (and (setq enampt (entsel "Select a block: "))
                    (setq enam (car enampt))
                    (setq entt (entget enam))
                    (setq typ (cdr (assoc 0 entt))))))
        ((/= "INSERT" typ)
         (prompt "That was not a block insert."))
        ((xrefp enam)
         (prompt "This program does not work with Xrefs."))
        (t
         (princ (setq blnam (cdr (assoc 2 entt))))
         (cond ((null (setq lissa (xistr "blup")))
                (prompt "No existing xrecord."))
               ((member blnam lissa)
                (remux "blup" (list blnam))
                (prompt (strcat "\n" (strcase (substr blnam 1 1))
                                (substr blnam 2)
                                " removed from auto-update list.")))
               (t (prompt (strcat "\n" (strcase (substr blnam 1 1))
                                (substr blnam 2)
                                " is not set to auto-update."))))))
 ; Ŀ
 ;   Place an Undo end marker, exit.                                       
 ; 
  (command "undo" "end")
 (princ))

 ; Ŀ
 ;   Epulp - remove all unreferenced block names from the Blup xrecord.    
 ; 
 (DEFUN C:EPULP (/ lissa blnam numa malist dalist)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq xrcnam "blup")
 ; Ŀ
 ;   Get the list of block names from the blup xrecord.                    
 ; 
  (setq lissa (xistr xrcnam))
 ; Ŀ
 ;   Remove any which do not name blocks defined in the drawing.           
 ; 
  (setq num 0)
  (while (setq blnam (nth num lissa))
         (setq num (1+ num))
         (if (and (tblsearch "block" blnam)
                  (null (xrefp blnam)))
             (setq malist (cons blnam malist))))
  (setq malist (reverse malist))
 ; Ŀ
 ;   Make the string list into a list of assoc 1 sublists.                 
 ; 
  (mapcar '(lambda (sub) (setq dalist (cons (cons 1 sub) dalist)))
            malist)
 ; Ŀ
 ;   Delete the xrecord and make a new one.                                
 ; 
  (klix xrcnam)
  (setq dalist (append '((0 . "XRECORD") (100 . "AcDbXrecord")) dalist))
  (dictadd (namedobjdict) xrcnam (entmakex dalist))
 ; Ŀ
 ;   Place an Undo end marker, exit.                                       
 ; 
  (command "undo" "end")
 (princ))

 ; Ŀ
 ;   Hpulp - highlight all blocks named in the Blup xrecord.               
 ; 
 (DEFUN C:HPULP (/ lissa namb ss num enam)
  (setq lissa (xistr "blup"))
  (while (setq namb (car lissa))
         (setq lissa (cdr lissa))
         (setq ss (ssget "X" (list (cons 2 namb))))
         (setq num 0)
         (while (setq enam (ssname ss num))
                (setq num (1+ num))
                (redraw enam 3)))
 (princ))

 ; Ŀ
 ;   Pulp.                                                                 
 ; 
 (DEFUN C:PULP (/ enampt enam typ blnam lissa)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Get an entity, add its name to the Blup Xrecord.                      
 ; 
  (cond ((null (and (setq enampt (entsel "Select a block: "))
                    (setq enam (car enampt))
                    (setq entt (entget enam))
                    (setq typ (cdr (assoc 0 entt))))))
        ((/= "INSERT" typ)
         (prompt "That was not a block insert."))
        ((xrefp enam)
         (prompt "This program does not work with Xrefs."))
        (t
         (princ (setq blnam (strcase (cdr (assoc 2 entt)) t)))
         (setq lissa (xistr "blup"))
 ; Ŀ
 ;   Sub-Cond: there is no blup xrecord.                                   
 ; 
         (cond ((null (lixt "blup"))
                (maex "blup" (list blnam)))
 ; Ŀ
 ;   Sub-Cond: there is a blup xrecord and it contains the block name.     
 ; 
               ((member blnam lissa)
                (prompt (strcat "\n" (strcase (substr blnam 1 1))
                                (substr blnam 2)
                                " is already set to auto-update.")))
 ; Ŀ
 ;   Default Sub-Cond - there must be a blup xrecord and it doesn't        
 ;   contain the block name, so add the latter to the former.              
 ; 
               (t (recux "blup" (list blnam))))))
 ; Ŀ
 ;   Place an Undo end marker, exit.                                       
 ; 
  (command "undo" "end")
 (princ))

(princ)